@extends('master.front')
@section('meta')
    <meta name="keywords" content="{{ $setting->meta_keywords }}">
    <meta name="description" content="{{ $setting->meta_description }}">
@endsection

@section('content')


    @php
        function renderStarRating($rating, $maxRating = 5)
        {
            $fullStar = "<i class = 'far fa-star filled'></i>";
            $halfStar = "<i class = 'far fa-star-half filled'></i>";
            $emptyStar = "<i class = 'far fa-star'></i>";
            $rating = $rating <= $maxRating ? $rating : $maxRating;
        
            $fullStarCount = (int) $rating;
            $halfStarCount = ceil($rating) - $fullStarCount;
            $emptyStarCount = $maxRating - $fullStarCount - $halfStarCount;
        
            $html = str_repeat($fullStar, $fullStarCount);
            $html .= str_repeat($halfStar, $halfStarCount);
            $html .= str_repeat($emptyStar, $emptyStarCount);
            $html = $html;
            return $html;
        }
    @endphp

    @if ($extra_settings->is_t2_slider == 1)
        <div class="slider-area-wrapper mt-0">
            <!-- Main Slider-->
            <div class="hero-slider">
                <div class="hero-slider-main owl-carousel dots-inside">
                    @foreach ($sliders as $slider)
                        <div class="item
                            @if (DB::table('languages')->where('is_default', 1)->first()->rtl == 1) d-flex justify-content-end @endif
                            "
                            style="background: url('{{ asset('assets/images/' . $slider->photo) }}')">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-8">
                                        <div class="item-inner">
                                            <div class="from-bottom">
                                                @if ($slider->logo)
                                                    <img class="d-inline-block brand-logo"
                                                        src="{{ asset('assets/images/' . $slider->logo) }}" alt="logo">
                                                @endif

                                                <div class="title text-body">{{ $slider->title }}</div>
                                                <div class="subtitle text-body">{{ $slider->details }}</div>
                                            </div>
                                            @if($slider->link != '#')
                                            <a class="btn btn-primary scale-up delay-1" href="{{ $slider->link }}">
                                                <span>{{ __('Buy Now') }}</span>
                                            </a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    @if ($extra_settings->is_t2_service_section == 1)
        <section class="service-section mt-30 pt-0">
            <div class="container">
                <div class="row">
                    @foreach ($services as $service)
                        <div class="col-lg-3 col-sm-6 text-center mb-30">
                            <div class="single-service single-service2">
                                <img src="{{ asset('assets/images/' . $service->photo) }}" alt="Shipping">
                                <div class="content">
                                    <h6 class="mb-2">{{ $service->title }}</h6>
                                    <p class="text-sm text-muted mb-0">{{ $service->details }}</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    @if ($extra_settings->is_t2_3_column_banner_first == 1)
        <div class="bannner-section mt-30">
            <div class="container ">
                <div class="row gx-3">
                    <div class="col-md-4">
                        <a href="{{ $banner_first['firsturl1'] }}" class="genius-banner">
                            <img src="{{ asset('assets/images/' . $banner_first['img1']) }}" alt="">
                            <div class="inner-content">
                                @if (isset($banner_first['subtitle1']))
                                    <p>{{ $banner_first['subtitle1'] }}</p>
                                @endif
                                @if (isset($banner_first['title1']))
                                    <h4>{{ $banner_first['title1'] }}</h4>
                                @endif
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="{{ $banner_first['firsturl2'] }}" class="genius-banner">
                            <img src="{{ asset('assets/images/' . $banner_first['img2']) }}" alt="">
                            <div class="inner-content">
                                @if (isset($banner_first['subtitle2']))
                                    <p>{{ $banner_first['subtitle2'] }}</p>
                                @endif
                                @if (isset($banner_first['title2']))
                                    <h4>{{ $banner_first['title2'] }}</h4>
                                @endif
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="{{ $banner_first['firsturl3'] }}" class="genius-banner">
                            <img src="{{ asset('assets/images/' . $banner_first['img3']) }}" alt="">
                            <div class="inner-content">
                                @if (isset($banner_first['subtitle3']))
                                    <p>{{ $banner_first['subtitle3'] }} </p>
                                @endif
                                @if (isset($banner_first['title3']))
                                    <h4>{{ $banner_first['title3'] }}</h4>
                                @endif
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endif


    @if ($extra_settings->is_t2_falsh == 1)
        <div class="flash-sell-new-section mt-50">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 ">
                        <div class="section-title section-title2 section-title3section-title section-title2 section-title3">
                            <h2 class="h3">{{ __('Flash Deal') }}</h2>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="main-content">
                            <div class="flash-deal-slider owl-carousel">
                                @foreach ($products->orderBy('id', 'DESC')->get() as $item)
                                    @if ($item->is_type == 'flash_deal' && $item->date != null)
                                        <div class="slider-item">
                                            <div class="product-card ">
                                                <div class="product-thumb">
                                                    @if (!$item->is_stock())
                                                        <div
                                                            class="product-badge bg-secondary border-default text-body
                                                ">
                                                            {{ __('out of stock') }}</div>
                                                    @endif
                                                    @if ($item->previous_price && $item->previous_price != 0)
                                                        <div class="product-badge product-badge2 bg-info">
                                                            -{{ PriceHelper::DiscountPercentage($item) }}</div>
                                                    @endif
                                                    <img class="lazy"
                                                        data-src="{{ asset('assets/images/' . $item->thumbnail) }}"
                                                        alt="Product">
                                                    <div class="product-button-group"><a
                                                            class="product-button wishlist_store"
                                                            href="{{ route('user.wishlist.store', $item->id) }}"
                                                            title="{{ __('Wishlist') }}"><i class="icon-heart"></i></a>
                                                        <a data-target="{{ route('fornt.compare.product', $item->id) }}"
                                                            class="product-button product_compare" href="javascript:;"
                                                            title="{{ __('Compare') }}"><i class="icon-repeat"></i></a>
                                                        @include('includes.item_footer', [
                                                            'sitem' => $item,
                                                        ])
                                                    </div>
                                                </div>
                                                <div class="product-card-inner">
                                                    <div class="product-card-body">

                                                        <div class="product-category"><a
                                                                href="{{ route('front.catalog') . '?category=' . $item->category->slug }}">{{ $item->category->name }}</a>
                                                        </div>
                                                        <h3 class="product-title"><a
                                                                href="{{ route('front.product', $item->slug) }}">
                                                                {{ Str::limit($item->name, 50) }}
                                                            </a></h3>
                                                        <div class="rating-stars">
                                                            {!! renderStarRating($item->reviews->avg('rating')) !!}
                                                        </div>
                                                        <h4 class="product-price">
                                                            @if ($item->previous_price != 0)
                                                                <del>{{ PriceHelper::setPreviousPrice($item->previous_price) }}</del>
                                                            @endif

                                                            {{ PriceHelper::grandCurrencyPrice($item) }}
                                                        </h4>
                                                        @if (date('d-m-y') != \Carbon\Carbon::parse($item->date)->format('d-m-y'))
                                                            <div class="countdown countdown-alt mb-3"
                                                                data-date-time="{{ $item->date }}">
                                                            </div>
                                                        @endif
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif


    @if ($extra_settings->is_t2_new_product == 1)
        <section class="selected-product-section mt-50 theme2">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-title section-title2 section-title3">
                            <h2 class="h3">{{ __('New  Products') }}</h2>
                        </div>
                    </div>
                </div>
                <div class="row">

                    <div class="col-lg-12">

                        <div class="features-slider  owl-carousel">
                            @foreach ($products->orderBy('id', 'DESC')->get() as $key => $item)
                                @if ($key <= 9)
                                    <div class="slider-item">
                                        <div class="product-card ">
                                            <div class="product-thumb">
                                                @if (!$item->is_stock())
                                                    <div
                                                        class="product-badge bg-secondary border-default text-body
                                                ">
                                                        {{ __('out of stock') }}</div>
                                                @endif
                                                @if ($item->previous_price && $item->previous_price != 0)
                                                    <div class="product-badge product-badge2 bg-info">
                                                        -{{ PriceHelper::DiscountPercentage($item) }}</div>
                                                @endif
                                                <img class="lazy"
                                                    data-src="{{ asset('assets/images/' . $item->thumbnail) }}"
                                                    alt="Product">
                                                <div class="product-button-group"><a class="product-button wishlist_store"
                                                        href="{{ route('user.wishlist.store', $item->id) }}"
                                                        title="{{ __('Wishlist') }}"><i class="icon-heart"></i></a>
                                                    <a data-target="{{ route('fornt.compare.product', $item->id) }}"
                                                        class="product-button product_compare" href="javascript:;"
                                                        title="{{ __('Compare') }}"><i class="icon-repeat"></i></a>
                                                    @include('includes.item_footer', ['sitem' => $item])
                                                </div>
                                            </div>
                                            <div class="product-card-inner">
                                                <div class="product-card-body">
                                                    <div class="product-category"><a
                                                            href="{{ route('front.catalog') . '?category=' . $item->category->slug }}">{{ $item->category->name }}</a>
                                                    </div>
                                                    <h3 class="product-title"><a
                                                            href="{{ route('front.product', $item->slug) }}">
                                                            {{ Str::limit($item->name, 35) }}
                                                        </a></h3>
                                                    <div class="rating-stars">
                                                        {!! renderStarRating($item->reviews->avg('rating')) !!}
                                                    </div>
                                                    <h4 class="product-price">
                                                        @if ($item->previous_price != 0)
                                                            <del>{{ PriceHelper::setPreviousPrice($item->previous_price) }}</del>
                                                        @endif
                                                        {{ PriceHelper::grandCurrencyPrice($item) }}
                                                    </h4>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                @else
                                @break
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif

@if ($extra_settings->is_t2_3_column_banner_second == 1)
    <div class="bannner-section mt-60">
        <div class="container ">
            <div class="row gx-3">
                <div class="col-md-4">
                    <a href="{{ $banner_secend['url1'] }}" class="genius-banner">
                        <img class="lazy" data-src="{{ asset('assets/images/' . $banner_secend['img1']) }}"
                            alt="">
                        <div class="inner-content">
                            @if (isset($banner_secend['subtitle1']))
                                <p>{{ $banner_secend['subtitle1'] }}</p>
                            @endif

                            @if (isset($banner_secend['title1']))
                                <h4>{{ $banner_secend['title1'] }}</h4>
                            @endif
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="{{ $banner_secend['url2'] }}" class="genius-banner">
                        <img class="lazy" data-src="{{ asset('assets/images/' . $banner_secend['img2']) }}"
                            alt="">
                        <div class="inner-content">
                            @if (isset($banner_secend['subtitle2']))
                                <p>{{ $banner_secend['subtitle2'] }}</p>
                            @endif

                            @if (isset($banner_secend['title2']))
                                <h4> {{ $banner_secend['title2'] }}</h4>
                            @endif
                        </div>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="{{ $banner_secend['url3'] }}" class="genius-banner">
                        <img class="lazy" data-src="{{ asset('assets/images/' . $banner_secend['img3']) }}"
                            alt="">
                        <div class="inner-content">
                            @if (isset($banner_secend['subtitle3']))
                                <p>{{ $banner_secend['subtitle3'] }} </p>
                            @endif

                            @if (isset($banner_secend['title3']))
                                <h4>{{ $banner_secend['title3'] }}</h4>
                            @endif
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
@endif

@if ($extra_settings->is_t2_featured_product == 1)
    <section class="selected-product-section mt-50 theme2">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title section-title2 section-title3">
                        <h2 class="h3">{{ __('Featured Products') }}</h2>
                    </div>
                </div>
            </div>
            <div class="row">

                <div class="col-lg-12">

                    <div class="features-slider  owl-carousel">
                        @foreach ($products->orderBy('id', 'DESC')->get() as $item)
                            @if ($item->is_type == 'feature')
                                <div class="slider-item">
                                    <div class="product-card ">
                                        <div class="product-thumb">
                                            @if (!$item->is_stock())
                                                <div
                                                    class="product-badge bg-secondary border-default text-body
                                                    ">
                                                    {{ __('out of stock') }}</div>
                                            @endif
                                            @if ($item->previous_price && $item->previous_price != 0)
                                                <div class="product-badge product-badge2 bg-info">
                                                    -{{ PriceHelper::DiscountPercentage($item) }}</div>
                                            @endif
                                            <img class="lazy"
                                                data-src="{{ asset('assets/images/' . $item->thumbnail) }}"
                                                alt="Product">
                                            <div class="product-button-group"><a class="product-button wishlist_store"
                                                    href="{{ route('user.wishlist.store', $item->id) }}"
                                                    title="{{ __('Wishlist') }}"><i class="icon-heart"></i></a>
                                                <a data-target="{{ route('fornt.compare.product', $item->id) }}"
                                                    class="product-button product_compare" href="javascript:;"
                                                    title="{{ __('Compare') }}"><i class="icon-repeat"></i></a>
                                                @include('includes.item_footer', ['sitem' => $item])
                                            </div>
                                        </div>
                                        <div class="product-card-inner">
                                            <div class="product-card-body">
                                                <div class="product-category"><a
                                                        href="{{ route('front.catalog') . '?category=' . $item->category->slug }}">{{ $item->category->name }}</a>
                                                </div>
                                                <h3 class="product-title"><a
                                                        href="{{ route('front.product', $item->slug) }}">
                                                        {{ Str::limit($item->name, 35) }}
                                                    </a></h3>
                                                <div class="rating-stars">
                                                    {!! renderStarRating($item->reviews->avg('rating')) !!}
                                                </div>
                                                <h4 class="product-price">
                                                    @if ($item->previous_price != 0)
                                                        <del>{{ PriceHelper::setPreviousPrice($item->previous_price) }}</del>
                                                    @endif
                                                    {{ PriceHelper::grandCurrencyPrice($item) }}
                                                </h4>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>

            </div>
        </div>
    </section>
@endif

@if ($extra_settings->is_t2_bestseller_product == 1)
    <section class="selected-product-section mt-50  theme2">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title section-title2  section-title3">
                        <h2 class="h3">{{ __('Best Seller') }}</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="features-slider  owl-carousel">
                        @foreach ($products->orderBy('id', 'DESC')->get() as $item)
                            @if ($item->is_type == 'best')
                                <div class="slider-item">
                                    <div class="product-card ">
                                        <div class="product-thumb">
                                            @if (!$item->is_stock())
                                                <div
                                                    class="product-badge bg-secondary border-default text-body
                                                ">
                                                    {{ __('out of stock') }}</div>
                                            @endif
                                            @if ($item->previous_price && $item->previous_price != 0)
                                                <div class="product-badge product-badge2 bg-info">
                                                    -{{ PriceHelper::DiscountPercentage($item) }}</div>
                                            @endif
                                            <img class="lazy"
                                                data-src="{{ asset('assets/images/' . $item->thumbnail) }}"
                                                alt="Product">
                                            <div class="product-button-group"><a class="product-button wishlist_store"
                                                    href="{{ route('user.wishlist.store', $item->id) }}"
                                                    title="{{ __('Wishlist') }}"><i class="icon-heart"></i></a>
                                                <a data-target="{{ route('fornt.compare.product', $item->id) }}"
                                                    class="product-button product_compare" href="javascript:;"
                                                    title="{{ __('Compare') }}"><i class="icon-repeat"></i></a>
                                                @include('includes.item_footer', ['sitem' => $item])
                                            </div>

                                        </div>
                                        <div class="product-card-inner">
                                            <div class="product-card-body">
                                                <div class="product-category"><a
                                                        href="{{ route('front.catalog') . '?category=' . $item->category->slug }}">{{ $item->category->name }}</a>
                                                </div>
                                                <h3 class="product-title"><a
                                                        href="{{ route('front.product', $item->slug) }}">
                                                        {{ Str::limit($item->name, 35) }}
                                                    </a></h3>
                                                <div class="rating-stars">
                                                    {!! renderStarRating($item->reviews->avg('rating')) !!}
                                                </div>
                                                <h4 class="product-price">
                                                    @if ($item->previous_price != 0)
                                                        <del>{{ PriceHelper::setPreviousPrice($item->previous_price) }}</del>
                                                    @endif
                                                    {{ PriceHelper::grandCurrencyPrice($item) }}
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>

            </div>
        </div>
    </section>
@endif

@if ($extra_settings->is_t2_toprated_product == 1)
    <section class="selected-product-section mt-50  theme2">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title section-title2  section-title3">
                        <h2 class="h3">{{ __('Top Rated') }}</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">

                    <div class="features-slider  owl-carousel">
                        @foreach ($products->orderBy('id', 'DESC')->get() as $item)
                            @if ($item->is_type == 'top')
                                <div class="slider-item">
                                    <div class="product-card ">
                                        <div class="product-thumb">
                                            @if (!$item->is_stock())
                                                <div
                                                    class="product-badge bg-secondary border-default text-body
                                                ">
                                                    {{ __('out of stock') }}</div>
                                            @endif
                                            @if ($item->previous_price && $item->previous_price != 0)
                                                <div class="product-badge product-badge2 bg-info">
                                                    -{{ PriceHelper::DiscountPercentage($item) }}</div>
                                            @endif
                                            <img class="lazy"
                                                data-src="{{ asset('assets/images/' . $item->thumbnail) }}"
                                                alt="Product">
                                            <div class="product-button-group"><a class="product-button wishlist_store"
                                                    href="{{ route('user.wishlist.store', $item->id) }}"
                                                    title="{{ __('Wishlist') }}"><i class="icon-heart"></i></a>
                                                <a data-target="{{ route('fornt.compare.product', $item->id) }}"
                                                    class="product-button product_compare" href="javascript:;"
                                                    title="{{ __('Compare') }}"><i class="icon-repeat"></i></a>
                                                @include('includes.item_footer', ['sitem' => $item])
                                            </div>
                                        </div>
                                        <div class="product-card-inner">
                                            <div class="product-card-body">
                                                <div class="product-category"><a
                                                        href="{{ route('front.catalog') . '?category=' . $item->category->slug }}">{{ $item->category->name }}</a>
                                                </div>
                                                <h3 class="product-title"><a
                                                        href="{{ route('front.product', $item->slug) }}">
                                                        {{ Str::limit($item->name, 35) }}
                                                    </a></h3>
                                                <div class="rating-stars">
                                                    {!! renderStarRating($item->reviews->avg('rating')) !!}
                                                </div>
                                                <h4 class="product-price">
                                                    @if ($item->previous_price != 0)
                                                        <del>{{ PriceHelper::setPreviousPrice($item->previous_price) }}</del>
                                                    @endif
                                                    {{ PriceHelper::grandCurrencyPrice($item) }}
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>

            </div>
        </div>
    </section>
@endif

@if ($extra_settings->is_t2_2_column_banner == 1)
    <div class="bannner-section mt-50">
        <div class="container ">
            <div class="row gx-3">
                <div class="col-md-6">
                    <a href="{{ $banner_third['url1'] }}" class="genius-banner">
                        <img class="lazy" data-src="{{ asset('assets/images/' . $banner_third['img1']) }}"
                            alt="">
                        <div class="inner-content">
                            @if (isset($banner_third['subtitle1']))
                                <p>{{ $banner_third['subtitle1'] }}</p>
                            @endif
                            @if (isset($banner_third['title1']))
                                <h4>{{ $banner_third['title1'] }}</h4>
                            @endif
                        </div>
                    </a>
                </div>
                <div class="col-md-6">
                    <a href="{{ $banner_third['url2'] }}" class="genius-banner">
                        <img class="lazy" data-src="{{ asset('assets/images/' . $banner_third['img2']) }}"
                            alt="">
                        <div class="inner-content">
                            @if (isset($banner_third['subtitle2']))
                                <p>{{ $banner_third['subtitle2'] }} </p>
                            @endif
                            @if (isset($banner_third['title2']))
                                <h4>{{ $banner_third['title2'] }}</h4>
                            @endif
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
@endif

@if ($extra_settings->is_t2_three_column_category == 1)
    <div class="flash-sell-area three_column_product mt-50">
        <div class="container">
            <div class="row gx-3 justify-content-center">
                @foreach ($two_column_categoriess as $two_column_key => $two_column_category)
                    <div class="col-xl-4 col-lg-6">
                        <div class="section-title">
                            <h2 class="h3">{{ $two_column_category['name']->name }}</h2>
                        </div>
                        <div class="main-content">
                            <div class="newproduct-slider owl-carousel">
                                @foreach ($two_column_categoriess[$two_column_key]['items']->chunk(4) as $two_column_category_itemt)
                                    <div class="slider-item">
                                        @foreach ($two_column_category_itemt as $two_column_category_item)
                                            <div class="product-card p-col">
                                                <a class="product-thumb"
                                                    href="{{ route('front.product', $two_column_category_item->slug) }}">
                                                    @if (!$two_column_category_item->is_stock())
                                                        <div
                                                            class="product-badge bg-secondary border-default text-body
                                                ">
                                                            {{ __('out of stock') }}</div>
                                                    @endif

                                                    <img class="lazy"
                                                        data-src="{{ asset('assets/images/' . $two_column_category_item->thumbnail) }}"
                                                        alt="Product">
                                                </a>
                                                <div class="product-card-body">
                                                    <h3 class="product-title"><a
                                                            href="{{ route('front.product', $two_column_category_item->slug) }}">
                                                            {{ Str::limit($two_column_category_item->name, 40) }}
                                                        </a></h3>
                                                    <div class="rating-stars">
                                                        {!! renderStarRating($two_column_category_item->reviews->avg('rating')) !!}
                                                    </div>
                                                    <h4 class="product-price">
                                                        @if ($two_column_category_item->previous_price != 0)
                                                            <del>{{ PriceHelper::setPreviousPrice($two_column_category_item->previous_price) }}</del>
                                                        @endif
                                                        {{ PriceHelper::grandCurrencyPrice($two_column_category_item) }}
                                                    </h4>
                                                </div>
                                            </div>
                                        @endforeach

                                    </div>
                                @endforeach
                            </div>

                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </div>
@endif

@if ($extra_settings->is_t2_blog_section == 1)
    <div class="blog-section-h page_section mt-50 mb-30">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title section-title2 section-title3">
                        <h2 class="h3">{{ __('Our Blog') }}</h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="home-blog-slider owl-carousel">
                        @foreach ($posts as $post)
                            <div class="slider-item">
                                <a href="{{ route('front.blog.details', $post->slug) }}" class="blog-post">
                                    <div class="post-thumb">
                                        <img class="lazy"
                                            data-src="{{ asset('assets/images/' . json_decode($post->photo, true)[array_key_first(json_decode($post->photo, true))]) }}"
                                            alt="Blog Post">
                                    </div>
                                    <div class="post-body">

                                        <h3 class="post-title"> {{ Str::limit($post->title, 55) }}
                                        </h3>
                                        <ul class="post-meta">

                                            <li><i class="icon-user"></i>{{ __('Admin') }}</li>
                                            <li><i
                                                    class="icon-clock"></i>{{ date('jS F, Y', strtotime($post->created_at)) }}
                                            </li>
                                        </ul>
                                        <p>{{ Str::limit(strip_tags($post->details), 120, '...') }}
                                        </p>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif

@if ($extra_settings->is_t2_brand_section == 1)
    <section class="brand-section  mt-30 mb-60">
        <div class="container ">
            <div class="row">
                <div class="col-lg-12 ">
                    <div class="section-title section-title2  section-title3">
                        <h2 class="h3">{{ __('Popular Brands') }}</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="brand-slider owl-carousel">
                        @foreach ($brands as $brand)
                            <div class="slider-item">
                                <a class="text-center"
                                    href="{{ route('front.catalog') . '?brand=' . $brand->slug }}">
                                    <img class="d-block hi-50 lazy"
                                        data-src="{{ asset('assets/images/' . $brand->photo) }}"
                                        alt="{{ $brand->name }}" title="{{ $brand->name }}">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif

@endsection
